function createCockpitSoundLoop(sound_host, start_sound_length, sdef_name_start, sdef_name_loop, sdef_name_end)
	start_length_ = start_sound_length or 0
	
	if sdef_name_start then
		sound_start_ = createCockpitSound(sound_host, sdef_name_start)
	else
		sound_start_ = nil
	end
	
	sound_loop_ = createCockpitSound(sound_host, sdef_name_loop)
	
	if sdef_name_end then
		sound_end_ = createCockpitSound(sound_host, sdef_name_end)
	else
		sound_end_ = nil
	end	
	
	return {
		startLength = start_length_,
		timePlaying = 0,
		isPlaying = false,
		sound_start = sound_start_,
		sound_loop = sound_loop_,
		sound_end = sound_end_,
	}
end

function stopSound(sound)	
	if sound and sound:is_playing() then
		sound:stop()		
	end	
end

function playSoundOnce(sound)
    if sound then
		if sound:is_playing() then
			sound:stop()
		end    
		sound:play_once()
	end
   
end

function stopLoopSound(loopSound, playEndSound)
	stopSound(loopSound.sound_start)
	stopSound(loopSound.sound_loop)
	loopSound.isPlaying = false
	loopSound.timePlaying = 0
	if playEndSound then
		playSoundOnce(loopSound.sound_end)
	end
end

function updateLoopingSound(command, loopSound)
	if command > -1 then
		if loopSound then
			if command == 0 and loopSound.isPlaying then
				--Stop command given
				stopLoopSound(loopSound, true)
			elseif command > 0 then
				--Play command given
				if loopSound.isPlaying then
					-- first stop if playing
					stopLoopSound(loopSound)
				end
				
				if loopSound.sound_start then
					loopSound.sound_start:play_once()
				end
				loopSound.isPlaying = true
			end
		end		
	else
		--no sound command given, manage start/looping sound
		if loopSound.isPlaying then
			loopSound.timePlaying = loopSound.timePlaying + dt
			
			if loopSound.sound_start and loopSound.sound_start:is_playing() then
				if loopSound.timePlaying > (loopSound.startLength - dt) then					
					loopSound.sound_loop:play_continue()
				end
				if loopSound.timePlaying > loopSound.startLength then
					loopSound.sound_start:stop()
					loopSound.sound_loop:play_continue()
				end
			else
				loopSound.sound_loop:play_continue()
			end
		end
	end
end

